﻿/* Skript zur Demonstration von Views
 * Als Benutzer SCOTT ausführen
 */

-- Erstellung einer einfachen View
create or replace view emp_vw as
select e.ename mitarbeiter,
       d.dname abteilung,
       m.ename manager,
       e.job beruf,
       s.grade gehaltsstufe
  from emp e
  join dept d on e.deptno = d.deptno
  left join emp m on e.mgr = m.empno
  join salgrade s
    on e.sal between s.losal and s.hisal;


-- Demonstration der Klausel force
create or replace force view emp_wrong_vw as
select e.ename mitarbeiter,
       d.dname abteilung,
       m.ename manager,
       e.jobname beruf,
       s.grade gehaltsstufe
  from emp e
  join dept d on e.deptno = d.deptno
  left join emp m on e.mgr = m.empno
  join salgrade s
    on e.sal between s.losal and s.hisal;

-- Abfrage gegen das Data Dictionary zum Status der View
select object_name, status
  from user_objects
 where object_type = 'VIEW';
 
-- Übersicht über die Views, die SCOTT zur Verfügung stehen
select *
  from all_objects
 where object_type = 'VIEW';
 
-- Dokumentation der Klausel WITH CHECK OPTION
create or replace view emp_dept_20 as
select ename, job, sal, hiredate, deptno
  from emp
 where deptno = 20
  with check option;
  
-- Nicht erlaubte Aktualisierung
update emp_dept_20
   set deptno = 30
 where ename = 'ADAMS';

rollback;

-- Verwendung der Klausel READ ONLY
create or replace view emp_dept_30 as
select ename, job, sal, hiredate, deptno
  from emp
 where deptno = 30
  with read only constraint chk_emp_dept_ro;
  
-- Verstoß gegen die Option:
update emp_dept_30
   set ename = 'RINGER'
 where ename = 'TURNER';
 
rollback;

-- Anzeige der benannten Constraints
select constraint_name, constraint_type, table_name
  from user_constraints;
  
-- Darstellung der aktualisierbaren Views
select table_name, column_name, 
       updatable upd, insertable ins, deletable del
  from user_updatable_columns
 where table_name in (select view_name
                        from user_views);